/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.BDGraphicsDevice;
import java.awt.BDImage;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import org.videolan.Logger;

abstract class BDGraphicsConfigurationBase
extends GraphicsConfiguration {
    private BDGraphicsDevice device;

    BDGraphicsConfigurationBase(BDGraphicsDevice device) {
        this.device = device;
    }

    @Override
    public GraphicsDevice getDevice() {
        return this.device;
    }

    @Override
    public Rectangle getBounds() {
        return this.device.getBounds();
    }

    int getCompatibleImageType() {
        return 2;
    }

    @Override
    public ColorModel getColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        return BDImage.getBuffededImage(width, height, this);
    }

    @Override
    public BufferedImage createCompatibleImage(int width, int height, int trans) {
        if (width <= 0 || height <= 0) {
            return null;
        }
        return BDImage.getBuffededImage(width, height, this);
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height) {
        Logger.unimplemented((String)"BDGraphicsConfiguration", (String)"createCompatibleVolatileImage");
        return null;
    }
}

